/*!
*******************************************************************************
* \file             MySpinAudioStream.cpp
* \brief            Implements the Audio functionality for mySPIN
*******************************************************************************
\verbatim
PROJECT:        Gen3 Projects
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Audio Streaming (Lib) Implementation for mySPIN using gstreamer
COPYRIGHT:      &copy; BSOT

HISTORY:
Date       |  Author                          | Modifications
19.02.2016 |  L. Weise (wel2hi)               | initial version

\endverbatim
******************************************************************************/

#include "mspin_audio_stream.h"
#include "spi_tclMySpinAudioStream.h"
#include "mspin_logging.h"
#ifdef USE_GENERATED_MYSPIN_VERSION_FILE
#include "mspin_version.h"
#endif


MySpinAudioStream::MySpinAudioStream() :
   m_poMySpinAudioStream(NULL)
{
   m_poMySpinAudioStream = new spi_tclMySpinAudioStream();

   if( NULL == m_poMySpinAudioStream )
   {
      mspin_log_printLn(eMspinVerbosityFatal, "%s() "
            "Creation of spi_tclMySpinAudioStream failed.",__PRETTY_FUNCTION__ );
   }
}

MySpinAudioStream::~MySpinAudioStream()
{
   if( NULL != m_poMySpinAudioStream )
   {
      delete m_poMySpinAudioStream;
      m_poMySpinAudioStream = NULL;
   }
}

S32 MySpinAudioStream::setAudioStreamConfig(const audioStreamConfig audStreamConfig)
{
   S32 retVal = -1;

   if( NULL != m_poMySpinAudioStream )
   {
      retVal = m_poMySpinAudioStream->SetAudioStreamConfig(audStreamConfig);
   }

   return(retVal);
}

S32 MySpinAudioStream::setAudioStreamInputDevice( std::string inDeviceName, audioStreamDeviceType audStreamDeviceType )
{
   S32 retVal = -1;

   if( NULL != m_poMySpinAudioStream )
   {
      retVal = m_poMySpinAudioStream->SetAudioStreamInputDevice(inDeviceName,audStreamDeviceType);
   }

   return(retVal);
}

S32 MySpinAudioStream::setAudioStreamOutputDevice( std::string outDeviceName )
{
   S32 retVal = -1;

   if( NULL != m_poMySpinAudioStream )
   {
      retVal = m_poMySpinAudioStream->SetAudioStreamOutputDevice(outDeviceName);
   }

   return(retVal);
}

S32 MySpinAudioStream::startAudioStream()
{
   S32 retVal = -1;

   if( NULL != m_poMySpinAudioStream )
   {
#ifdef MYSPIN_GIT_VERSION
      mspin_log_printLn(eMspinVerbosityInfo,
            "%s() mySpin AudioStreamLib version %s", __FUNCTION__, MYSPIN_GIT_VERSION); //print version info
#else
      mspin_log_printLn(eMspinVerbosityInfo,
            "%s() mySpin AudioStreamLib version %s", __FUNCTION__, "n/a"); //Git version not available
#endif //#ifdef MYSPIN_GIT_VERSION

      retVal = m_poMySpinAudioStream->StartAudioStream();
   }

   return(retVal);
}

S32 MySpinAudioStream::stopAudioStream()
{
   S32 retVal = -1;

   if( NULL != m_poMySpinAudioStream )
   {
      retVal = m_poMySpinAudioStream->StopAudioStream();
   }

   return(retVal);
}

void MySpinAudioStream::registerCallbacks(U32 context, audioStreamCallbacks audioCallbacks)
{
   (void)context;            // currently unused

   if( NULL != m_poMySpinAudioStream )
   {
      m_poMySpinAudioStream->vRegisterCallbacks(context,audioCallbacks);
   }
}

